using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
		      double y;
		      int act, f, r;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               pdf.SetFont("Helvetica", TFStyle.fsRegular, 10.0, false, TCodepage.cp1252);
               pdf.WriteText(50.0, 50.0, "Normal check boxes.");

               pdf.ChangeFontSize(1.0);
               f = pdf.CreateCheckBox("N1", "C1", true, -1, 50.0,  70.0, 20.0, 20.0);
               pdf.SetCheckBoxDefState(f, true);
               f = pdf.CreateCheckBox("N2", "C2", true, -1, 80.0,  70.0, 20.0, 20.0);
               pdf.SetCheckBoxDefState(f, true);
               f = pdf.CreateCheckBox("N3", "C1", true, -1, 110.0, 70.0, 20.0, 20.0);
               pdf.SetCheckBoxDefState(f, true);

               pdf.ChangeFontSize(10.0);
               pdf.WriteText(50.0, 100.0, "Field group with check boxes.");

               pdf.ChangeFontSize(1.0);
               pdf.CreateCheckBox("G1", "C1", false, -1, 50.0, 120.0, 20.0, 20.0);
               pdf.CreateCheckBox("G1", "C2", false, -1, 80.0, 120.0, 20.0, 20.0);
               pdf.CreateCheckBox("G1", "C1", true, -1, 110.0, 120.0, 20.0, 20.0);

               pdf.ChangeFontSize(10.0);
               pdf.WriteFTextEx(50.0, 150.0, 220.0, -1.0, TTextAlign.taLeft, "This group works like a radio button but only radio buttons get a round border if the check box character is set to ccCircle. No problem, set the border width to zero and draw the circle in background if needed.");

               y = pdf.GetPageHeight() - pdf.GetLastTextPosY() + 10.0;

               pdf.ChangeFontSize(1.0);
               pdf.SetCheckBoxChar(TCheckBoxChar.ccCircle);
               pdf.CreateCheckBox("G2", "C1", false, -1, 50.0, y, 20.0, 20.0);
               pdf.CreateCheckBox("G2", "C2", false, -1, 80.0, y, 20.0, 20.0);
               pdf.CreateCheckBox("G2", "C3", true, -1, 110.0, y, 20.0, 20.0);


               pdf.ChangeFontSize(10.0);
               pdf.WriteFTextEx(300.0, 50.0, 250.0, -1.0, TTextAlign.taLeft, "This is a radio button. Since Acrobat 7 it is no longer possible to deselect the active check box, except with a reset form or Javascript action.");

               y = pdf.GetPageHeight() - pdf.GetLastTextPosY() + 10.0;

               pdf.ChangeFontSize(15.0);
               r = pdf.CreateRadioButton("Radio1", "R1", true, -1, 300.0, y, 20.0, 20.0);
               pdf.SetCheckBoxDefState(r, false);
               pdf.CreateCheckBox(null, "R2", false, r, 330.0, y, 20.0, 20.0);
               pdf.CreateCheckBox(null, "R3", false, r, 360.0, y, 20.0, 20.0);

               pdf.ChangeFontSize(10.0);
               f = pdf.CreateButton("Reset", "Reset", -1, 400.0, y, 60.0, 20.0);
               pdf.SetFieldColor(f, TFieldColor.fcBackColor, TPDFColorSpace.csDeviceRGB, CPDF.PDF_LTGRAY);
               pdf.SetFieldBorderStyle(f, TBorderStyle.bsBevelled);

               act = pdf.CreateResetAction();
               pdf.AddActionToObj(TObjType.otField, TObjEvent.oeOnMouseUp, act, f);
               pdf.AddFieldToFormAction(act, r, true);

               y += 40.0;
               pdf.ChangeFontSize(10.0);
               pdf.WriteFTextEx(300.0, y, 250.0, -1.0, TTextAlign.taLeft, "The RadioIsUnion flag has only an effect if at least two check boxes use the same export value.");
               y = pdf.GetPageHeight() - pdf.GetLastTextPosY() + 10.0;

               pdf.ChangeFontSize(15.0);
               r = pdf.CreateRadioButton("Radio2", "R1", true, -1, 300.0, y, 20.0, 20.0);
               pdf.SetFieldFlags(r, TFieldFlags.ffRadioIsUnion, false);
               pdf.CreateCheckBox(null, "R2", false, r, 330.0, y, 20.0, 20.0);
               pdf.CreateCheckBox(null, "R1", true, r, 360.0, y, 20.0, 20.0);
               pdf.CreateCheckBox(null, "R2", false, r, 390.0, y, 20.0, 20.0);
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
